/********************************************
; File: FOUNDATION.h
;
; Copyright Marc Wolfgram, 1991
; All Rights Reserved
;
; last revised:  11/14/91
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __GSOS__
#include <GSOS.h>
#endif

#ifndef __RESOURCES__
#include <resources.h>
#endif

#ifndef __FOUNDATION__
#define __FOUNDATION__

/*
    The following structures are defined for the Foundation REM entry blocks
    ------------------------------------------------------------------------
    REM_OPEN
 */
struct fOpenRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x0200 Data valid, 0x0100 Silent */
    Handle  Data;
    Pointer wColorPtr;
};
typedef struct fOpenRec fOpenRec, *fOpenRecPtr;

/*
    REM_CLOSE
    REM_WRITE
    REM_PRINT
 */
struct fCloseRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x4000 640 mode */
    Pointer windowPtr;
};
typedef struct fCloseRec fCloseRec, *fCloseRecPtr;

/*
    REM_EVENT
 */
struct fEventRec {
    word    resType;
    long    resID;
    word    fFlag,
            taskCode;
};
typedef struct fEventRec fEventRec, *fEventRecPtr;

/*
    REM_ACTIVATE
 */
struct fActivateRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x8000 bit is activate */
    Handle  linkHand;       /* null if no link references */
};
typedef struct fActivateRec fActivateRec, *fActivateRecPtr;

/*
    REM_GETLINK
 */
struct fLinkRec {
    word    resType;
    long    resID;
    word    resFileID;      /* null if current workfile */
    Handle  linkHand;
};
typedef struct fLinkRec fLinkRec, *fLinkRecPtr;

/*
    REM_VIDMODE
 */
struct fVidModeRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x4000 640 mode */
    Pointer windowPtr,
            wColorPtr;
};
typedef struct fVidModeRec fVidModeRec, *fVidModeRecPtr;

/*
    REM_STARTUP
    REM_SHUTDOWN
 */
struct fStartStopRec {
    word    edUserID,
            edResFileID,
            shResFileID,
            fdResFileID;
};
typedef struct fStartStopRec fStartStopRec, *fStartStopRecPtr;

/*
    The following structures are defined for the Foundation CallBack commands
    -------------------------------------------------------------------------
    fAddResource
    fLoadResource
    fGetResourceAttr
    fGetScrap
    fRequestEdit
    fSaveScrap
    fSelectorMenu
    fSelectorRequest
    fSetResourceAttr
    fSpecialMagic
 */
struct fResDataRec {
    word    pCount,
            resType;
    long    resID;
    Handle  resData;
    word    special,
            resFileID;
    Pointer resName;
};
typedef struct fResDataRec fResDataRec, *fResDataRecPtr;

/*
    fCountResources
    fGetIndResource
    fGetResourceSize
    fSetResourceID
 */
struct fResData2Rec {
    word    pCount,
            resType;
    long    resID,
            result;
    word    resFileID;
};
typedef struct fResData2Rec fResData2Rec, *fResData2RecPtr;

/*
    fRemoveResource
    fReleaseResource
    fDetachResource
    fWriteResource
    fUniqueResourceID
 */
struct fResRefRec {
    word    pCount,
            resType;
    long    resID;
    word    resFileID;
};
typedef struct fResRefRec fResRefRec, *fResRefRecPtr;

/*
    fGetStdTypeName
    fGetResourceName
    fSetResourceName
    fGetWindowTitle
 */
struct fResNameRec {
    word    pCount,
            resType;
    long    resID;
    char   *resName; /* pascal string */
};
typedef struct fResNameRec fResNameRec, *fResNameRecPtr;

/*
    fBuildLinkHand
    fDisposeLinkHand
    fExtendLinkHand
    fFindHostLink
    fQueryLinkHand
 */
struct fResLinkRec {
    word    pCount,
            index;
    Handle  linkHand;
    word    hostType;
    long    hostID;
    word    resType;
    long    resID;
    word	resCheck,
            resFileID;
};
typedef struct fResLinkRec fResLinkRec, *fResLinkRecPtr;

/*
    fLoadFileData
 */
struct fLoadFileRec {
    word    pCount;
    Handle  fileData;
    long    sfGet2ReplyRecPtr,
            sfGet2PromptRefPtr,
            sfGet2FileTypeRecPtr,
            sfGet2FilterProcPtr;
};
typedef struct fLoadFileRec fLoadFileRec, *fLoadFileRecPtr;

/*
    fGetPrivateData
    fSetPrivateData
 */
struct fPrivateDataRec {
    word    pCount;
    Pointer winPtr;
    long    remTaskMask;
    word    remSignature;
    Handle  Data;
    word    groupSignature, /* init only */
            resType;        /* init only */
    long    resID;          /* init only */
};
typedef struct fPrivateDataRec fPrivateDataRec, *fPrivateDataRecPtr;

/*
    fResourceConverter
 */
struct fResConverterRec {
    word    pCount,
            resType;
    long    converterProc;
    word    logFlags;
};
typedef struct fResConverterRec fResConverterRec, *fResConverterRecPtr;

/*
    fCopyResource
 */
struct fResCopyRec {
    word    pCount,
            resType;
    long    resID,
            newID;
    word    attr,
            resFileID,
            newFileID;
    Pointer resName;
};
typedef struct fResCopyRec fResCopyRec, *fResCopyRecPtr;

/*
    The following structures are defined for the REM preference resource 0x7ffb
    ---------------------------------------------------------------------------
*/
struct remPrefRef {
    word    resTag,
            resType;
    long    resID;
};
typedef struct remPrefRef remRef, *remRefPtr;

struct remPrefRes {
    remRef  ref[1];
};
typedef struct remPrefRes *remPrefPtr, **remPrefHndl;

/*
    The following defines provide Foundation CallBack entry access
    --------------------------------------------------------------
*/
extern pascal word FSTACK();

#define fAddPrivateData(pBlockPtr) FSTACK(26,pBlockPtr)
#define fAddResource(pBlockPtr) FSTACK(1,pBlockPtr)
#define fBuildLinkHand(pBlockPtr) FSTACK(11,pBlockPtr)
#define fCopyResource(pBlockPtr) FSTACK(25,pBlockPtr)
#define fCountResources(pBlockPtr) FSTACK(18,pBlockPtr)
#define fDetachResource(pBlockPtr) FSTACK(5,pBlockPtr)
#define fDisposeLinkHand(pBlockPtr) FSTACK(28,pBlockPtr)
#define fExtendLinkHand(pBlockPtr) FSTACK(10,pBlockPtr)
#define fFindHostLink(pBlockPtr) FSTACK(36,pBlockPtr)
#define fGetEditorStatus(pBlockPtr) FSTACK(33,pBlockPtr)
#define fGetIndResource(pBlockPtr) FSTACK(19,pBlockPtr)
#define fGetPrivateData(pBlockPtr) FSTACK(15,pBlockPtr)
#define fGetResourceAttr(pBlockPtr) FSTACK(22,pBlockPtr)
#define fGetResourceName(pBlockPtr) FSTACK(8,pBlockPtr)
#define fGetResourceSize(pBlockPtr) FSTACK(20,pBlockPtr)
#define fGetStdTypeName(pBlockPtr) FSTACK(7,pBlockPtr)
#define fGetWindowTitle(pBlockPtr) FSTACK(29,pBlockPtr)
#define fLoadFileData(pBlockPtr) FSTACK(13,pBlockPtr)
#define fLoadResource(pBlockPtr) FSTACK(3,pBlockPtr)
#define fLoadScrap(pBlockPtr) FSTACK(31,pBlockPtr)
#define fQueryLinkHand(pBlockPtr) FSTACK(12,pBlockPtr)
#define fRelPrivateData(pBlockPtr) FSTACK(27,pBlockPtr)
#define fReleaseResource(pBlockPtr) FSTACK(4,pBlockPtr)
#define fRemoveResource(pBlockPtr) FSTACK(2,pBlockPtr)
#define fRequestEdit(pBlockPtr) FSTACK(14,pBlockPtr)
#define fResourceConverter(pBlockPtr) FSTACK(24,pBlockPtr)
#define fSaveScrap(pBlockPtr) FSTACK(32,pBlockPtr)
#define fSelectorMenu(pBlockPtr) FSTACK(35,pBlockPtr)
#define fSelectorRequest(pBlockPtr) FSTACK(34,pBlockPtr)
#define fSetPrivateData(pBlockPtr) FSTACK(16,pBlockPtr)
#define fSetResourceAttr(pBlockPtr) FSTACK(23,pBlockPtr)
#define fSetResourceID(pBlockPtr) FSTACK(21,pBlockPtr)
#define fSetResourceName(pBlockPtr) FSTACK(9,pBlockPtr)
#define fSpecialMagic(pBlockPtr) FSTACK(30,pBlockPtr)
#define fSpinCursor() FSTACK(37, 0L)
#define fUniqueResourceID(pBlockPtr) FSTACK(17,pBlockPtr)
#define fWriteResource(pBlockPtr) FSTACK(6,pBlockPtr)
#endif
